/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S21PacketChunkData;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMassiveTree
extends WorldGenerator {
    private static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    private static final float PI = (float)Math.PI;
    private Random rand = new Random();
    private World worldObj;
    private int[][] leafNodes;
    private int[] basePos = new int[]{0, 0, 0};
    private int heightLimit = 0;
    private int height;
    private int leafBases;
    private int leafNodesLength;
    private int density;
    private final List<WeightedRandomBlock> leaves;
    private final List<WeightedRandomBlock> trunk;
    private final WeightedRandomBlock[] genBlock;
    private boolean generated = false;
    public boolean smoothLogs = false;
    public boolean slopeTrunk = false;
    public boolean safeGrowth = true;
    public boolean treeChecks = true;
    public boolean fastPlacement = false;
    public boolean relightBlocks = true;
    public WeightedRandomBlock[] genSurface = null;
    public int minHeight = -1;
    public int leafDistanceLimit = 4;
    public int heightLimitLimit = 250;
    public float heightAttenuation = 0.45f;
    public float branchDensity = 1.0f;
    public float branchSlope = 0.381f;
    public float scaleWidth = 1.0f;
    public int trunkSize = 11;
    private int[] placeScratch = new int[3];
    private int[] checkScratch = new int[3];
    private TLongObjectHashMap<Chunk> chunkMap;

    public WorldGenMassiveTree(List<WeightedRandomBlock> list, List<WeightedRandomBlock> list2, List<WeightedRandomBlock> list3) {
        super(false);
        this.trunk = list;
        this.leaves = list2;
        this.genBlock = list3.toArray(new WeightedRandomBlock[list3.size()]);
    }

    private void setup() {
        this.leafBases = MathHelper.ceiling_float_int((float)((float)this.heightLimit * this.heightAttenuation));
        this.density = Math.max(1, (int)(1.382 + Math.pow((double)(this.branchDensity * (float)this.heightLimit) / 13.0, 2.0)));
        this.chunkMap = new TLongObjectHashMap((int)(this.scaleWidth * (float)this.heightLimit));
    }

    private float layerSize(int n) {
        float f;
        if (n < this.leafBases) {
            return -1.618f;
        }
        float f2 = (float)this.heightLimit * 0.5f;
        float f3 = (float)this.heightLimit * 0.5f - (float)n;
        if (f3 == 0.0f) {
            f = f2;
        } else {
            if (Math.abs(f3) >= f2) {
                return 0.0f;
            }
            f = (float)Math.sqrt(f2 * f2 - f3 * f3);
        }
        return f *= 0.5f;
    }

    private void generateLeafNodeList() {
        int n = this.density;
        int[] nArray = this.basePos;
        int[][] nArray2 = new int[n * this.heightLimit][4];
        int n2 = nArray[1] + this.heightLimit - this.leafDistanceLimit;
        int n3 = 1;
        int n4 = nArray[1] + this.height;
        int n5 = n2 - nArray[1];
        nArray2[0][0] = nArray[0];
        nArray2[0][1] = n2--;
        nArray2[0][2] = nArray[2];
        nArray2[0][3] = n4;
        while (n5 >= 0) {
            float f = this.layerSize(n5);
            if (f > 0.0f) {
                float f2 = 0.5f;
                for (int i = 0; i < n; ++i) {
                    float f3 = this.scaleWidth * f * (this.rand.nextFloat() + 0.328f);
                    float f4 = this.rand.nextFloat() * 2.0f * (float)Math.PI;
                    int n6 = MathHelper.floor_double((double)((double)f3 * Math.sin(f4) + (double)nArray[0] + (double)f2));
                    int n7 = MathHelper.floor_double((double)((double)f3 * Math.cos(f4) + (double)nArray[2] + (double)f2));
                    int[] nArray3 = new int[]{n6, n2, n7};
                    int[] nArray4 = new int[]{n6, n2 + this.leafDistanceLimit, n7};
                    if (this.checkBlockLine(nArray3, nArray4) != -1) continue;
                    int n8 = nArray[0] - nArray3[0];
                    int n9 = n8 * n8;
                    n8 = nArray[2] - nArray3[2];
                    double d = Math.sqrt(n9 + n8 * n8);
                    int n10 = (int)(d * (double)this.branchSlope);
                    int[] nArray5 = new int[]{nArray[0], Math.min(nArray3[1] - n10, n4), nArray[2]};
                    if (this.checkBlockLine(nArray5, nArray3) != -1) continue;
                    nArray2[n3][0] = n6;
                    nArray2[n3][1] = n2;
                    nArray2[n3][2] = n7;
                    nArray2[n3][3] = nArray5[1];
                    ++n3;
                }
            }
            --n2;
            --n5;
        }
        this.leafNodes = nArray2;
        this.leafNodesLength = n3;
    }

    private void genLeafLayer(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n3;
        float f = n4 * n4;
        for (int i = -n4; i <= n4; ++i) {
            float f2;
            n = n5 + i;
            int n7 = i >> 31;
            int n8 = i * i + ((n7 ^ i) - n7);
            for (int j = 0; j <= n4 && !((f2 = (float)(n8 + j * j + j) + 0.5f) > f); ++j) {
                for (n7 = -1; n7 <= 1; n7 += 2) {
                    n3 = n6 + j * n7;
                    Block block = this.worldObj.getBlock(n, n2, n3);
                    if (!(this.safeGrowth ? WorldGenMinableCluster.canGenerateInBlock(this.worldObj, n, n2, n3, this.genBlock) && (!this.treeChecks || block.isAir((IBlockAccess)this.worldObj, n, n2, n3) || block.isLeaves((IBlockAccess)this.worldObj, n, n2, n3) || block.canBeReplacedByLeaves((IBlockAccess)this.worldObj, n, n2, n3)) : block.getBlockHardness(this.worldObj, n, n2, n3) >= 0.0f)) continue;
                    WeightedRandomBlock weightedRandomBlock = WorldGenMinableCluster.selectBlock(this.worldObj, this.leaves);
                    this.setBlockAndNotifyAdequately(this.worldObj, n, n2, n3, weightedRandomBlock.block, weightedRandomBlock.metadata);
                }
            }
        }
    }

    private void generateLeaves() {
        int[][] nArray = this.leafNodes;
        int n = this.leafNodesLength;
        for (int i = 0; i < n; ++i) {
            int n2;
            int[] nArray2 = nArray[i];
            int n3 = nArray2[0];
            int n4 = nArray2[1];
            int n5 = nArray2[2];
            int n6 = n2 + this.leafDistanceLimit;
            for (n2 = 0; n2 < n6; ++n2) {
                int n7 = n2 != 0 & n2 != this.leafDistanceLimit - 1 ? 3 : 2;
                this.genLeafLayer(n3, n4++, n5, n7);
            }
        }
    }

    private void placeBlockLine(int[] nArray, int[] nArray2, List<WeightedRandomBlock> list, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray3 = this.placeScratch;
        int n6 = 0;
        for (n5 = 0; n5 < 3; n5 = (int)((byte)(n5 + 1))) {
            n4 = nArray2[n5] - nArray[n5];
            n3 = n4 >> 31;
            n2 = (n3 ^ n4) - n3;
            nArray3[n5] = n4;
            n4 = nArray3[n6];
            n3 = n4 >> 31;
            if (n2 <= (n4 ^ n3) - n3) continue;
            n6 = n5;
        }
        if (nArray3[n6] != 0) {
            n5 = otherCoordPairs[n6];
            n4 = otherCoordPairs[n6 + 3];
            n2 = nArray3[n6] > 0 ? 1 : -1;
            float f = (float)nArray3[n5] / (float)nArray3[n6];
            float f2 = (float)nArray3[n4] / (float)nArray3[n6];
            int n7 = nArray3[n6] + n2;
            int[] nArray4 = nArray3;
            for (int i = 0; i != n7; i += n2) {
                nArray4[n6] = MathHelper.floor_float((float)((float)(nArray[n6] + i) + 0.5f));
                nArray4[n5] = MathHelper.floor_float((float)((float)nArray[n5] + (float)i * f + 0.5f));
                nArray4[n4] = MathHelper.floor_float((float)((float)nArray[n4] + (float)i * f2 + 0.5f));
                int n8 = nArray4[0] - nArray[0];
                n3 = n8 >> 31;
                n8 = (n3 ^ n8) - n3;
                int n9 = nArray4[2] - nArray[2];
                n3 = n9 >> 31;
                n9 = (n3 ^ n9) - n3;
                int n10 = Math.max(n8, n9);
                int n11 = n;
                if (this.smoothLogs & n10 > 0) {
                    if (n8 == n10) {
                        n11 |= 4;
                    } else if (n9 == n10) {
                        n11 |= 8;
                    }
                }
                WeightedRandomBlock weightedRandomBlock = WorldGenMinableCluster.selectBlock(this.worldObj, this.trunk);
                this.setBlockAndNotifyAdequately(this.worldObj, nArray4[0], nArray4[1], nArray4[2], weightedRandomBlock.block, weightedRandomBlock.metadata | n11);
            }
        }
    }

    private void generateTrunk() {
        int n = this.basePos[0];
        int n2 = this.basePos[1];
        int n3 = this.basePos[1] + this.height;
        int n4 = this.basePos[2];
        int[] nArray = new int[]{n, n2, n4};
        int[] nArray2 = new int[]{n, n3, n4};
        double d = 400.0f / (float)this.trunkSize;
        for (int i = -this.trunkSize; i <= this.trunkSize; ++i) {
            nArray[0] = n + i;
            nArray2[0] = n + i;
            for (int j = -this.trunkSize; j <= this.trunkSize; ++j) {
                if ((j * j + i * i) * 4 >= this.trunkSize * this.trunkSize * 5) continue;
                nArray[2] = n4 + j;
                nArray2[2] = n4 + j;
                if (this.slopeTrunk) {
                    nArray2[1] = n2 + WorldGenMassiveTree.sinc2(d * (double)i, d * (double)j, this.height) - (this.rand.nextInt(3) - 1);
                }
                this.placeBlockLine(nArray, nArray2, this.trunk, 0);
                if (this.smoothLogs) {
                    this.setBlockAndNotifyAdequately(this.worldObj, nArray2[0], nArray2[1], nArray2[2], null, 12);
                }
                this.worldObj.getBlock(nArray[0], nArray[1] - 1, nArray[2]).onPlantGrow(this.worldObj, nArray[0], nArray[1] - 1, nArray[2], n, n2, n4);
            }
        }
    }

    private static final int sinc2(double d, double d2, int n) {
        double d3 = d / Math.PI;
        double d4 = d3 * d3;
        d3 = d2 / Math.PI;
        if ((d3 = Math.sqrt(d4 + d3 * d3) * Math.PI / 180.0) == 0.0) {
            return n;
        }
        return (int)Math.round((double)n * ((Math.sin(d3) / d3 + Math.sin(d3 * 2.0943951023931953) / (d3 * 2.0943951023931953)) / 2.0));
    }

    void generateLeafNodeBases() {
        int[] nArray = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        int[][] nArray2 = this.leafNodes;
        int n = (int)((float)this.heightLimit * 0.2f);
        int n2 = this.smoothLogs ? 12 : 0;
        int n3 = this.leafNodesLength;
        for (int i = 0; i < n3; ++i) {
            int[] nArray3 = nArray2[i];
            nArray[1] = nArray3[3];
            int n4 = nArray[1] - this.basePos[1];
            if (n4 < n) continue;
            this.placeBlockLine(nArray, nArray3, this.trunk, n2);
        }
    }

    private int checkBlockLine(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray3 = this.checkScratch;
        int n7 = 0;
        for (n6 = 0; n6 < 3; n6 = (int)((byte)(n6 + 1))) {
            n5 = nArray2[n6] - nArray[n6];
            n4 = n5 >> 31;
            n3 = (n4 ^ n5) - n4;
            nArray3[n6] = n5;
            n5 = nArray3[n7];
            n4 = n5 >> 31;
            if (n3 <= (n5 ^ n4) - n4) continue;
            n7 = n6;
        }
        if (nArray3[n7] == 0) {
            return -1;
        }
        n6 = otherCoordPairs[n7];
        n5 = otherCoordPairs[n7 + 3];
        n3 = nArray3[n7] > 0 ? 1 : -1;
        float f = (float)nArray3[n6] / (float)nArray3[n7];
        float f2 = (float)nArray3[n5] / (float)nArray3[n7];
        int n8 = nArray3[n7] + n3;
        int[] nArray4 = nArray3;
        for (n2 = 0; n2 != n8; n2 += n3) {
            nArray4[n7] = nArray[n7] + n2;
            nArray4[n6] = MathHelper.floor_float((float)((float)nArray[n6] + (float)n2 * f));
            nArray4[n5] = MathHelper.floor_float((float)((float)nArray[n5] + (float)n2 * f2));
            int n9 = nArray4[0];
            int n10 = nArray4[1];
            int n11 = nArray4[2];
            Block block = this.worldObj.getBlock(n9, n10, n11);
            if (this.safeGrowth ? WorldGenMinableCluster.canGenerateInBlock(this.worldObj, n9, n10, n11, this.genBlock) && (!this.treeChecks || !block.isAir((IBlockAccess)this.worldObj, n9, n10, n11) && !block.isReplaceable((IBlockAccess)this.worldObj, n9, n10, n11) && !block.canBeReplacedByLeaves((IBlockAccess)this.worldObj, n9, n10, n11) && !block.isLeaves((IBlockAccess)this.worldObj, n9, n10, n11) && !block.isWood((IBlockAccess)this.worldObj, n9, n10, n11) && !(block instanceof BlockSapling)) : block.getBlockHardness(this.worldObj, n9, n10, n11) >= 0.0f) break;
        }
        if (n2 == n8) {
            n = -1;
        } else {
            n4 = n2 >> 31;
            n = (n4 ^ n2) - n4;
        }
        return n;
    }

    private boolean validTreeLocation() {
        int n = Math.min(this.heightLimit + this.basePos[1], 255) - this.basePos[1];
        if (n < this.minHeight) {
            return false;
        }
        this.heightLimit = n;
        if (!WorldGenMinableCluster.canGenerateInBlock(this.worldObj, this.basePos[0], this.basePos[1] - 1, this.basePos[2], this.genSurface)) {
            return false;
        }
        int[] nArray = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        int[] nArray2 = new int[]{this.basePos[0], this.basePos[1] + this.heightLimit - 1, this.basePos[2]};
        n = this.checkBlockLine(nArray, nArray2);
        if (n == -1) {
            n = this.heightLimit;
        }
        if (n < this.minHeight) {
            return false;
        }
        this.heightLimit = Math.min(n, this.heightLimitLimit);
        this.height = (int)((float)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        this.height += this.rand.nextInt(this.heightLimit - this.height);
        if (this.safeGrowth) {
            int n2 = this.basePos[0];
            int n3 = this.basePos[1];
            int n4 = this.basePos[1] + this.height;
            int n5 = this.basePos[2];
            nArray = new int[]{n2, n3, n5};
            nArray2 = new int[]{n2, n4, n5};
            double d = 400.0f / (float)this.trunkSize;
            for (int i = -this.trunkSize; i <= this.trunkSize; ++i) {
                nArray[0] = n2 + i;
                nArray2[0] = n2 + i;
                for (int j = -this.trunkSize; j <= this.trunkSize; ++j) {
                    int n6;
                    if ((j * j + i * i) * 4 >= this.trunkSize * this.trunkSize * 5) continue;
                    nArray[2] = n5 + j;
                    nArray2[2] = n5 + j;
                    if (this.slopeTrunk) {
                        nArray2[1] = n3 + WorldGenMassiveTree.sinc2(d * (double)i, d * (double)j, this.height);
                    }
                    if ((n6 = this.checkBlockLine(nArray, nArray2)) == -1) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void setScale(double d, double d2, double d3) {
        this.setTreeScale((float)d, (float)d2, (float)d3);
    }

    public WorldGenMassiveTree setTreeScale(float f, float f2, float f3) {
        this.heightLimitLimit = (int)((double)f * 12.0);
        this.minHeight = this.heightLimitLimit / 2;
        this.trunkSize = (int)Math.round((double)f / 2.0);
        this.leafDistanceLimit = this.minHeight > 30 ? 5 : this.minHeight / 8;
        this.scaleWidth = f2;
        this.branchDensity = f3;
        return this;
    }

    public WorldGenMassiveTree setMinTrunkSize(int n) {
        this.trunkSize = Math.max(n, this.trunkSize);
        return this;
    }

    public WorldGenMassiveTree setLeafAttenuation(float f) {
        this.heightAttenuation = f;
        return this;
    }

    public WorldGenMassiveTree setSloped(boolean bl) {
        this.slopeTrunk = bl;
        return this;
    }

    public WorldGenMassiveTree setSafe(boolean bl) {
        this.safeGrowth = bl;
        return this;
    }

    public synchronized boolean generate(World world, Random random, int n, int n2, int n3) {
        this.worldObj = world;
        long l = random.nextLong();
        this.rand.setSeed(l);
        this.basePos[0] = n;
        this.basePos[1] = n2;
        this.basePos[2] = n3;
        if (this.heightLimit == 0) {
            this.heightLimit = this.heightLimitLimit;
        }
        if (this.minHeight < 0) {
            this.minHeight = 80;
        }
        if (!this.validTreeLocation()) {
            this.worldObj = null;
            return false;
        }
        this.generated = false;
        this.setup();
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.generateTrunk();
        if (this.fastPlacement) {
            TLongObjectIterator tLongObjectIterator = this.chunkMap.iterator();
            while (tLongObjectIterator.hasNext()) {
                PlayerManager playerManager;
                NibbleArray nibbleArray;
                tLongObjectIterator.advance();
                Chunk chunk = (Chunk)tLongObjectIterator.value();
                chunk.generateSkylightMap();
                ExtendedBlockStorage[] extendedBlockStorageArray = chunk.getBlockStorageArray();
                if (!this.relightBlocks) {
                    int n4 = extendedBlockStorageArray.length;
                    while (n4-- > 0) {
                        if (extendedBlockStorageArray[n4] == null) continue;
                        nibbleArray = extendedBlockStorageArray[n4].getSkylightArray();
                        nibbleArray.set(0, 0, 0, 0);
                        nibbleArray.set(0, 0, 0, 15);
                        Arrays.fill(nibbleArray.data, (byte)0);
                    }
                    chunk.resetRelightChecks();
                }
                chunk.isModified = true;
                if (!(world instanceof WorldServer) || (playerManager = ((WorldServer)world).getPlayerManager()) == null || (nibbleArray = playerManager.getOrCreateChunkWatcher(chunk.xPosition, chunk.zPosition, false)) == null) continue;
                nibbleArray.sendToAllPlayersWatchingChunk((Packet)new S21PacketChunkData(chunk, false, -1));
            }
        }
        this.worldObj = null;
        return this.generated;
    }

    public void setBlockAndNotifyAdequately(World world, int n, int n2, int n3, Block block, int n4) {
        ExtendedBlockStorage[] extendedBlockStorageArray;
        ExtendedBlockStorage extendedBlockStorage;
        if (n2 < 0 | n2 > 255) {
            return;
        }
        this.generated = true;
        if (!this.fastPlacement) {
            if (block != null) {
                super.setBlockAndNotifyAdequately(world, n, n2, n3, block, n4);
            } else {
                world.setBlockMetadataWithNotify(n, n2, n3, world.getBlockMetadata(n, n2, n3) | n4, 2);
            }
            return;
        }
        long l = ((long)n & 0xFFFFFFF0L) << 32 | (long)n3 & 0xFFFFFFF0L;
        Chunk chunk = (Chunk)this.chunkMap.get(l);
        if (chunk == null) {
            chunk = world.getChunkFromBlockCoords(n, n3);
            this.chunkMap.put(l, (Object)chunk);
        }
        if ((extendedBlockStorage = (extendedBlockStorageArray = chunk.getBlockStorageArray())[n2 >> 4]) == null) {
            extendedBlockStorageArray[n2 >> 4] = extendedBlockStorage = new ExtendedBlockStorage(n2 & 0xFFFFFFF0, !world.provider.hasNoSky);
        }
        if (block != null && extendedBlockStorage.getBlockByExtId(n &= 0xF, n2 & 0xF, n3 &= 0xF).hasTileEntity(extendedBlockStorage.getExtBlockMetadata(n, n2 & 0xF, n3))) {
            chunk.removeTileEntity(n, n2, n3);
        }
        n2 &= 0xF;
        if (block != null) {
            extendedBlockStorage.func_150818_a(n, n2, n3, block);
            extendedBlockStorage.setExtBlockMetadata(n, n2, n3, n4);
        } else {
            extendedBlockStorage.setExtBlockMetadata(n, n2, n3, extendedBlockStorage.getExtBlockMetadata(n, n2, n3) | n4);
        }
        extendedBlockStorage.setExtBlocklightValue(n, n2, n3, 0);
    }
}

